unit TapeMakerV11aSrc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ComCtrls, ShellCtrls, StrUtils, DateUtils, IniFiles;

type
  String255 = string[255];
  TForm1 = class(TForm)
    Start: TButton;
    GetObject: TShellTreeView;
    FileList: TStringGrid;
    ClearFileList: TButton;
    InitializeTape: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    Destination: TEdit;
    Label2: TLabel;
    TapeVolSer: TEdit;
    Label3: TLabel;
    OwnerName: TEdit;
    Label4: TLabel;
    LReclWnd: TEdit;
    BlkSizeWnd: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    ExtLst: TStringGrid;
    Label7: TLabel;
    ClrExtLst: TButton;
    Stop: TButton;
    FileNoWnd: TEdit;
    Label8: TLabel;
    BlkNoWnd: TEdit;
    Label9: TLabel;
    ExitProc: TButton;
    Abort: TButton;
    procedure GetObjectClick(Sender: TObject);
    procedure FileListDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClearFileListClick(Sender: TObject);
    procedure StartClick(Sender: TObject);
    procedure InitializeTapeClick(Sender: TObject);
    procedure DestinationDblClick(Sender: TObject);
    procedure DestinationExit(Sender: TObject);
    procedure TapeVolSerExit(Sender: TObject);
    procedure OwnerNameExit(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LReclWndExit(Sender: TObject);
    procedure BlkSizeWndExit(Sender: TObject);
    procedure ClrExtLstClick(Sender: TObject);
    procedure ExtLstExit(Sender: TObject);
    procedure ExitProcClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure AbortClick(Sender: TObject);
  private
    procedure ProcessEntry(Entry: string255);
    procedure WriteFileToTape(FileName: string255);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

type
  LabelType = array[1..4] of char;
  Char2 = array[1..2] of char;
  Char4 = array[1..4] of char;
  Char6 = array[1..6] of char;
  Char10 = array[1..10] of char;
  Char13 = array[1..13] of char;
  WholeLabel = array[1..80] of char;
  AnsiVol1Record = record
    case Boolean of
      false: (
        HdrType: LabelType;
        Ser: char6;
        Reserved: array[1..27] of char;
        Owner: char10;
        Reserved2: array[1..28] of char;
        Version: char);

      true: (Data: WholeLabel);
  end;

  Hdr1Record = record
    case Boolean of
      false: (
        HdrType: LabelType;
        DSN: array[1..17] of char;
        VolSer: char6;
        VolSeq: Char4;
        DataSeq: Char4;
        Generation: Char4;
        GenerationVersion: Char2;
        CreationDate: char6;
        Expiration: char6;
        Secure: char;
        BlockCount: char6;
        SystemCode: char13;
        Reserved: array[1..7] of char);
      true: (Data: WholeLabel);
  end;

  Hdr2Record = record
    case Boolean of
      false: (
        HdrType: LabelType;
        Recfm: char; // F, V, U
        BlkSize: array[1..5] of char;
        LRecl: array[1..5] of char;
        RMSAttr: Char;
        Reserved: array[1..11] of char;
        CC: Char;
        Reserved1: array[1..22] of char;
        BufOffset: array[1..2] of char;
        Reserved2: array[1..28] of char);

      true: (Data: WholeLabel);
  end;
  OutBufferRecord = array[1..65536] of char;

const
  Vol1Id: LabelType = ('V', 'O', 'L', '1');
  EOVId: LabelType = ('E', 'O', 'V', '1');
  Hdr1Id: LabelType = ('H', 'D', 'R', '1');
  Hdr2Id: LabelType = ('H', 'D', 'R', '2');
  EOF1Id: LabelType = ('E', 'O', 'F', '1');
  EOF2Id: LabelType = ('E', 'O', 'F', '2');
  SystemCodeId: Char13 = ('D', 'E', 'C', 'F', 'I', 'L', 'E', '1', '1', 'A', ' ',
    ' ', ' ');

var
  AbortFlag: Boolean;
  BlkCt: Word;
  BlkNo: LongWord;
  BlkSize: word;
  BufferPtr: word;
  ByteCount: Integer;
  CurrentSelection: string255;
  CurrentSelectionValid: Boolean;
  DateString: string255;
  EmptyLabel: WholeLabel;
  FileNo: word;
//  FileOpen: Boolean;
  Hdr1, EOF1: Hdr1Record;
  Hdr2, EOF2: Hdr2Record;
  InFile: file;
  InitFile: TIniFile;
  InputBuffer: array[1..2044] of char;
  LRecl: word;
  OldFileName: string255;
  OutBuffer: OutBufferRecord;
  OutFile: file;
  OutFileOpen : Boolean;
  RtnCode: Integer;
  StopFlag: boolean;
  TmpStr: string255;
  Vol1, EOV: AnsiVol1Record;
  VolId: word;
  VolHdrWritten: boolean;

procedure WriteTapeMark();
const
  Zeros: Longword = 0;
begin
  if OutFileOpen then
    BlockWrite(OutFile, Zeros, 4);
  RtnCode := IOResult;
  if RtnCode <> 0 then
    Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) +
      ' writing tapemark');
end;

procedure WriteTapeRecord(DataPtr: Pointer; ByteCount: Integer);
var
  I: word;
  I2: Integer;
begin
  I2 := 4;
  BlockWrite(OutFile, ByteCount, I2);
  RtnCode := IOResult;
  if RtnCode <> 0 then
    Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) +
      ' Writing Block Prelude');
  BlockWrite(OutFile, DataPtr^, ByteCount);
  Inc(BlkNo);
  Form1.BlkNoWnd.Text := IntToStr(BlkNo);
  RtnCode := IOResult;
  if RtnCode <> 0 then
    Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) +
      ' Writing Bloc Data');
  BlockWrite(OutFile, ByteCount, I2);
  RtnCode := IOResult;
  if RtnCode <> 0 then
    Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) +
      ' Writing PostScript');
end;

procedure WriteEOT();
begin
  WriteTapeMark();
  WriteTapeMark();
end;

procedure Tform1.WriteFileToTape(FileName: string255);
var
  DotCt: word;
  FN: string[17];
  Offset: word;
  I: word;
  I2: Integer;
  RecL: Longword;

begin
  if (UpperCase(FileName) = UpperCase(Destination.Text)) then
  begin
    Memo1.Lines.Add('Bypassing ' + Destination.Text);
    exit;
  end;

  AssignFile(InFile, FileName);
  Reset(InFile, 1);
  RtnCode := IOResult;
  if RtnCode <> 0 then
  begin
    Memo1.Lines.add('Error ' + IntToStr(RtnCode) + ' on file ' + fileName);
    Memo1.Lines.add(SysErrorMessage(RtnCode));
    exit;
  end;

  if not OutFileOpen then
  begin
    Memo1.Lines.Add('Output file not open');
    exit;
  end;
  Memo1.Lines.Add('Processing ' + FileName);

  Inc(FileNo);
  FileNoWnd.Text := IntToStr(FileNo);
  Hdr1.Data := EmptyLabel;
  Hdr1.HdrType := Hdr1Id;
  Fn := UpperCase(ExtractFileName(FileName)) + '                ';
  DotCt := 0;
  for I := 1 to 17 do
  begin
    if FN[I] = '.' then
      Inc(DotCt);
    if (FN[I] = ' ') then
    begin
      TmpStr := Trim(RightStr(FN, 17 - I));
      if (TmpStr <> '') then
        FN[I] := '_';
    end;
  end;
  while DotCt > 1 do
  begin
    I := Pos('.', FN);
    Fn := LeftStr(FN, I - 1) + RightStr(FN, Length(FN) - I);
    Dec(DotCt);
  end;
  if (DotCt = 0) or (FN[17] = '.') then
    FN := LeftStr(FN, 15) + '.A';

  Move(Fn[1], Hdr1.Dsn, 17);
  Hdr1.VolSer := Vol1.Ser;
  Hdr1.VolSeq := '0001';
  TmpStr := RightStr('0000' + IntToStr(FileNo), 4);
  Move(TmpStr[1], Hdr1.DataSeq, 4);
  TmpStr := '0001';
  Move(TmpStr[1], Hdr1.Generation, 4);
  Move(TmpStr[1], Hdr1.GenerationVersion, 2);
  TmpStr := '000000';
  Move(TmpStr[1], Hdr1.BlockCount, 6);
  DateString := '0' + formatDateTime('yy', now) + IntToStr(DayOfTheYear(now));
  Move(DateString[1], Hdr1.CreationDate, 6);
  DateString := '0' + formatDateTime('yy', now) + IntToStr(DayOfTheYear(now +
    30));
  Move(DateString[1], Hdr1.Expiration, 6);
  //  Hdr1.SystemCode := SystemCodeId;
  BlkCt := 0;
  WriteTapeRecord(@Hdr1, SizeOf(Hdr1));

  Hdr2.HdrType := Hdr2Id;
  Hdr2.Recfm := 'F';
  Hdr2.CC := 'M';
//  WriteTapeMark();
  TmpStr := RightStr('00000' + IntToStr(Lrecl), 5);
  Move(TmpStr[1], Hdr2.LRecl, 5);
  TmpStr := RightStr('00000' + IntToStr(BlkSize), 5);
  Move(TmpStr[1], Hdr2.BlkSize, 5);
  WriteTapeRecord(@Hdr2, SizeOf(Hdr2));
  WriteTapeMark();

  BufferPtr := 1;
  while (not eof(InFile)) and (not AbortFlag) do
  begin
    BlockRead(InFile, InputBuffer, Lrecl, ByteCount);
    RtnCode := IOResult;
    if RtnCode <> 0 then
    begin
      Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) +
        ' Reading infile');
      exit;
    end;
    while ByteCount < Lrecl do
    begin
      Inc(ByteCount);
      InputBuffer[ByteCount] := char(0);
    end;
    if ((BufferPtr + ByteCount) > (BlkSize + 1)) then
    begin
      WriteTapeRecord(@OutBuffer, BufferPtr - 1);
      Inc(BlkCt);
      BufferPtr := 1;
      Application.ProcessMessages;
    end;
    Move(InputBuffer, OutBuffer[BufferPtr], ByteCount);
    BufferPtr := BufferPtr + ByteCount;
  end;
  if BufferPtr > 1 then
  begin
    while BufferPtr <= BlkSize do
    begin
      OutBuffer[BufferPtr] := '^';
      inc(BufferPtr);
    end;
    WriteTapeRecord(@OutBuffer, BufferPtr - 1);
    Inc(BlkCt);
  end;
  CloseFile(InFile);
  RtnCode := IOResult;
  if RtnCode <> 0 then
    Form1.memo1.lines.add(' IO error ' + IntToStr(RtnCode) + ' Closing Infile');
  WriteTapeMark();
  TmpStr := RightStr('000000' + IntToStr(BlkCt), 6);
  EOF1.Data := Hdr1.Data;
  EOF1.HdrType := EOF1ID;
  Move(TmpStr[1], EOF1.BlockCount, 6);
  WriteTapeRecord(@EOF1, SizeOf(EOF1));
  EOF2.Data := HDR2.Data;
  EOF2.HdrType := EOF2ID;
  WriteTapeRecord(@EOF2, SizeOf(EOF2));
  WriteTapeMark();
  Memo1.Lines.Add(' File ' + FileName + ' Written to tape as file ' +
    IntToStr(FileNo));
end;

procedure Tform1.ProcessEntry(Entry: string255);
var
  sr: TSearchRec;
  FileAttrs: Integer;
  FilePath: string;

  function FileExtSelected(FileName: string): Boolean;
  var
    I: word;
    Str1, Str2: string;
  begin
    Result := false;
    str1 := ExtractFileExt(UpperCase(Trim(FileName)));
    for I := 0 to ExtLst.RowCount do
    begin
      Str2 := UpperCase(Trim(ExtLst.Rows[I].Text));
      if (Str2 <> '') then
        if (Str1 = Str2) or (Str2 = '.*') then
        begin
          Result := True;
          exit;
        end;
    end;
  end;

begin
  FileAttrs := faAnyFile;
  FilePath := ExtractFileDir(Entry);
  if RightStr(FilePath, 1) <> '\' then
    FilePath := FilePath + '\';
  //  else FilePath := FilePath + '\' + ExtractFileDir(Entry);
  if StopFlag then
    exit;
  if FindFirst(Entry, FileAttrs, sr) = 0 then
  begin
    repeat
      if ((sr.Attr and faDirectory) = faDirectory) then
      begin
        if (sr.Name = '') then
          ProcessEntry(FilePath + '*.*')
        else if (sr.name <> '.') and (sr.name <> '..') then
          ProcessEntry(FilePath + sr.Name + '\*.*');
      end
      else if (sr.Attr and not (faSysFile or faVolumeId)) <> 0 then
        if (UpperCase(FilePath + '\' + sr.Name) = UpperCase(Destination.Text))
          then
          Memo1.Lines.Add(' Bypassing ' + Destination.Text)
        else if FileExtSelected(sr.Name) then
          WriteFileToTape(FilePath + sr.Name);
    until (FindNext(sr) <> 0) or StopFlag;
    if AbortFlag then
      InitializeTapeClick(self);
  end;
end;

procedure TForm1.GetObjectClick(Sender: TObject);
begin
  CurrentSelection := GetObject.Path;
  CurrentSelectionValid := True;
end;

procedure TForm1.FileListDblClick(Sender: TObject);
begin
  if CurrentSelectionValid then
  begin
    CurrentSelectionValid := false;
    CurrentSelection := Trim(CurrentSelection);
    if ((FileGetAttr(CurrentSelection) and faDirectory) = faDirectory) then
      CurrentSelection := CurrentSelection + '\*.*';
    FileList.Rows[FileList.Row].Text := Trim(CurrentSelection);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I: word;
  RtnCode: Integer;
begin
  FileNoWnd.Text := '';
  BlkNoWnd.Text := '';
  BlkNo := 0;
  ClearFileListClick(self);
  Memo1.Clear;
  VolHdrWritten := False;
  OutFileOpen := false;
  InitFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  Form1.Left := InitFile.ReadInteger('FormSetup', 'Left', 91);
  Form1.Top := InitFile.ReadInteger('FormSetup', 'Top', 144);
  Form1.Width := InitFile.ReadInteger('FormSetup', 'Width', 1263);
  Form1.Height := InitFile.ReadInteger('FormSetup', 'Height', 793);
  for I := 0 to FileList.RowCount do
    FileList.Rows[I].Text := InitFile.ReadString('FileList', 'File' +
      IntToStr(I), ' ');
  for I := 0 to ExtLst.RowCount do
    ExtLst.Rows[I].Text := InitFile.ReadString('FileList', 'Ext'
      + IntToStr(I), ' ');
  Destination.Text := InitFile.ReadString('TapeInfo', 'Destination', ' ');
  OldFileName := UpperCase(Trim(Destination.Text));
  TapeVolSer.Text := InitFile.ReadString('TapeInfo', 'VolSer', ' ');
  OwnerName.Text := InitFile.ReadString('TapeInfo', 'Owner', ' ');
  BlkSizeWnd.Text := InitFile.ReadString('TapeInfo', 'BlkSize', '512');
  LReclWnd.Text := InitFile.ReadString('TapeInfo', 'LRecl', '512');
  Val(BlkSizeWnd.Text, BlkSize, RtnCode);
  if (RtnCode <> 0) then
  begin
    BlkSizeWnd.Text := '512';
    Blksize := 512;
  end;
  Val(LReclWnd.Text, LRecl, RtnCode);
  if (RtnCode <> 0) then
  begin
    LReclWnd.Text := '512';
    LRecl := 512;
  end;
  if ((BlkSize mod LRecl) <> 0) then
  begin
    BlkSize := LRecl;
    BlkSizeWnd.Text := LReclWnd.Text;
  end;

  for I := 1 to 80 do
    EmptyLabel[I] := ' ';
  CurrentSelectionValid := false;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  I: word;
begin
  InitFile.WriteInteger('FormSetup', 'Top', Form1.Top);
  InitFile.WriteInteger('FormSetup', 'Left', Form1.Left);
  InitFile.WriteInteger('FormSetup', 'Height', Form1.Height);
  InitFile.WriteInteger('FormSetup', 'Width', Form1.Width);
  for I := 0 to FileList.RowCount do
    InitFile.WriteString('FileList', 'File' + IntToStr(I),
      FileList.Rows[I].Text);
  for I := 0 to ExtLst.RowCount do
    InitFile.WriteString('FileList', 'Ext' + IntToStr(I),
      ExtLst.Rows[I].Text);
  InitFile.WriteString('TapeInfo', 'Destination', Destination.Text);
  InitFile.WriteString('TapeInfo', 'VolSer', TapeVolSer.Text);
  InitFile.WriteString('TapeInfo', 'Owner', OwnerName.Text);
  InitFile.WriteString('TapeInfo', 'LRecl', LReclWnd.Text);
  InitFile.WriteString('TapeInfo', 'BlkSize', BlkSizeWnd.Text);

  if OutFileOpen then
  begin
    WriteEOT();
    CloseFile(OutFile);
    OutFileOpen := False;
  end;
end;

procedure TForm1.ClearFileListClick(Sender: TObject);
var
  I: word;
begin
  for I := 0 to FileList.RowCount do
    FileList.Rows[I].Clear;
end;

procedure TForm1.StartClick(Sender: TObject);
var
  I: word;
  Entry: string255;
begin
  StopFlag := false;
  AbortFlag := false;
  InitializeTape.Enabled := False;
  ExitProc.Enabled := False;
  Start.Enabled := false;
  FileList.Enabled := false;
  ExtLst.Enabled := false;
  BufferPtr := 0;
  if not OutFileOpen then
  InitializeTapeClick(self);
  I := 0;
  repeat
    Entry := Trim(FileList.Rows[I].Text);
    if (Entry <> '') then
    begin
      ProcessEntry(Entry);
    end;
    Inc(I);
  until (I > FileList.RowCount);
  //  ClearFileListClick(self);
  Memo1.Lines.Add('All Done');
  InitializeTape.Enabled := True;
  ExitProc.Enabled := True;
  Start.Enabled := True;
  FileList.Enabled := True;
  ExtLst.Enabled := True;
end;

procedure TForm1.InitializeTapeClick(Sender: TObject);
begin
  if not OutFileOpen then
  begin
    AssignFile(OutFile, Destination.Text);
    ReWrite(OutFile, 1);
    RtnCode := IOResult;
    if RtnCode <> 0 then
      Form1.memo1.lines.add(' IO error ' + IntToStr(Rtncode) +
        ' Opening outfile');
    OutFileOpen := True;
    Seek(OutFile, 0);

    // scan file & position to end of file....
  end;
  Memo1.Clear;
  FileNo := 0;
  VolId := 0;
  Vol1.Data := EmptyLabel;
  Hdr1.Data := EmptyLabel;
  EOF1.Data := EmptyLabel;
  Hdr2.Data := EmptyLabel;
  EOF2.Data := EmptyLabel;
  FileNoWnd.Text := '';
  BlkNoWnd.Text := '';
  BlkNo := 0;
  Vol1.Data := EmptyLabel;
  Vol1.HdrType := Vol1ID;
  TmpStr := OwnerName.Text + '              ';
  Move(TmpStr[1], Vol1.Owner, 14);
  TmpStr := Trim(TapeVolser.Text) + '      ';
  Move(TmpStr[1], Vol1.Ser, 6);
  Vol1.Version := '1';
  WriteTapeRecord(@Vol1, SizeOf(Vol1));
  Memo1.Lines.Add('Tape initialized');
end;

procedure TForm1.DestinationDblClick(Sender: TObject);
begin
  if CurrentSelectionValid then
  begin
    CurrentSelectionValid := false;
    Destination.Text := Trim(CurrentSelection);
  end;

end;

procedure TForm1.DestinationExit(Sender: TObject);
begin
  if (UpperCase(Trim(Destination.Text)) <> OldFileName) then
  begin
    if OutFileOpen then
    begin
      WriteEOT();
      CloseFile(OutFile);
    end;
    AssignFile(OutFile, Destination.Text);
    if FileExists(Destination.Text) then
    begin
      Reset(OutFile, 1);
      OutFileOpen := True;
      Seek(OutFile, 0);
      // scan file & position to end of file....
    end
    else
    begin
      ReWrite(OutFile, 1);
      OutFileOpen := True;
    end
  end;
  OldFileName := UpperCase(Trim(Destination.Text));
end;

procedure TForm1.TapeVolSerExit(Sender: TObject);
begin
  TapeVolSer.Text := UpperCase(Trim(TapeVolSer.Text)) + '      ';
  TapeVolSer.Text := LeftStr(TapeVolSer.Text, 6);
end;

procedure TForm1.OwnerNameExit(Sender: TObject);
begin
  OwnerName.Text := UpperCase(Trim(OwnerName.Text)) + '      ';
  OwnerName.Text := LeftStr(OwnerName.Text, 10);
end;

procedure TForm1.LReclWndExit(Sender: TObject);
var
  I: Integer;
  RtnCode: Integer;
begin
  Val(LReclWnd.Text, I, RtnCode);
  if (RtnCode <> 0) then
  begin
    Memo1.Lines.Add(' Invalid LRecl - (non-numeric) reset to previous value');
    LReclWnd.Text := IntToStr(LRecl);
    exit;
  end;
  if (I < 1) or (I > 65534) then
  begin
    Memo1.Lines.Add(' Invalid LRecl - (too large or too small) reset to previous value');
    LReclWnd.Text := IntToStr(LRecl);
    exit;
  end;
  LRecl := I;
  LReclWnd.Text := IntToStr(I);
  if (LRecl > Blksize) then
  begin
    Memo1.Lines.Add(' Lrecl > Blksize, Blksize reset');
    Blksize := LRecl;
    BlksizeWnd.Text := LReclWnd.Text;
  end;
  if ((BlkSize mod LRecl) <> 0) then
    Memo1.Lines.Add(' Blksize is not a multiple of LRecl - this is not recommended')
end;

procedure TForm1.BlkSizeWndExit(Sender: TObject);
var
  I: Integer;
  RtnCode: Integer;
begin
  Val(BlkSizeWnd.Text, I, RtnCode);
  if (RtnCode <> 0) then
  begin
    Memo1.Lines.Add(' Invalid BlkSize - (non-numeric) reset to previous value');
    BlkSizeWnd.Text := IntToStr(BlkSize);
    exit;
  end;
  if (I < 18) then
  begin
    Memo1.Lines.Add(' Invalid BlkSize - (too small) reset to previous value');
    BlkSizeWnd.Text := IntToStr(BlkSize);
    exit;
  end;
  if (I > 65536) then
  begin
    Memo1.Lines.Add(' Warning BlkSize > Ansi Standard of 2048 bytes - may not be supported on all systems');
    BlkSizeWnd.Text := IntToStr(BlkSize);
    exit;
  end;

  BlkSize := I;
  BlkSizeWnd.Text := IntToStr(I);

  if (LRecl > Blksize) then
  begin
    Memo1.Lines.Add(' Lrecl > Blksize, Blksize reset');
    Blksize := LRecl;
    BlksizeWnd.Text := LReclWnd.Text;
  end;

  if ((BlkSize mod LRecl) <> 0) then
    Memo1.Lines.Add(' Blksize is not a multiple of LRecl - this is not recommended');

end;

procedure TForm1.ClrExtLstClick(Sender: TObject);
var
  I: word;
begin
  for I := 0 to ExtLst.RowCount do
    ExtLst.Rows[I].Text := '';
end;

procedure TForm1.ExtLstExit(Sender: TObject);
var
  AllBlank: boolean;
  I, J: word;
  Str: string;
begin
  AllBlank := True;
  for I := 0 to ExtLst.RowCount do
  begin
    Str := UpperCase(Trim(ExtLst.Rows[I].Text));
    J := Pos('.', Str);
    if (J <> 0) then
      Str := RightStr(Str, Length(Str) - j);

    if LeftStr(Str, 1) <> '.' then
      Str := '.' + Str;
    if Str = '.' then
      Str := '';
    if Trim(Str) <> '' then
      AllBlank := false;
    ExtLst.Rows[I].Text := Str;
  end;
  if AllBlank then
    ExtLst.Rows[0].Text := '.*';
end;

procedure TForm1.ExitProcClick(Sender: TObject);
begin
  Close();
end;

procedure TForm1.StopClick(Sender: TObject);
begin
  StopFlag := True;
  InitializeTape.Enabled := True;
  ExitProc.Enabled := True;
  Start.Enabled := True;
  FileList.Enabled := True;
  ExtLst.Enabled := True;
  Memo1.Lines.Add('Stop issued');
end;

procedure TForm1.AbortClick(Sender: TObject);
begin
  AbortFlag := True;
  StopFlag := True;
end;

end.

initialization;

finalization;

end.

